(defun main (&rest args)
  (if (< (length args) 2)
      (format t "correct usage: bat [-solver (zchaff | minisat | siege | none) | -p (full | mem | cnf | none) | -r | +r | -s | +s | -u | +u]* file~%")
    (let ((file nil)
	  (up t)
	  (ap nil)
	  (rp t)
	  (sp nil)
	  (solver :siege))
      (setf args (cdr args))
      (loop until (endp args) do
	    (let ((arg (first args)))
	      (cond ((equal arg "-solver")
		     (let ((arg2 (second args)))
		       (cond ((equal arg2 "zchaff") (setf solver :zchaff))
			     ((equal arg2 "minisat") (setf solver :minisat))
			     ((equal arg2 "siege") (setf solver :siege))
			     ((equal arg2 "none") (setf solver :none))
			     (t (return (format t "unknown sat solver: ~A~%" (second args)))))
		       (setf args (cddr args))))
		    ((equal arg "-cnf")
		     (let ((arg2 (second args)))
		       (cond ((equal arg2 "ts") (setf *cnf* 'ts))
			     ((equal arg2 "mv") (setf *cnf* 'mv))
			     (t (return (format t "unknown cnf algorithm: ~A~%" (second args)))))
		       (setf args (cddr args))))
		    ((equal arg "-p")
		     (let ((arg2 (second args)))
		       (cond ((equal arg2 "full") (setf ap t))
			     ((equal arg2 "mem") (setf ap 'mem))
			     ((equal arg2 "cnf") (setf ap 'cnf))
			     ((equal arg2 "none") (setf ap nil))
			     (t (return (format t "unknown propagation option: ~A~%" arg2))))
		       (setf args (cddr args))))
		    ((equal arg "-policy")
		     (let ((arg2 (second args)))
		       (cond ((equal arg2 "clauses") (setf *var-policy* 'clauses))
			     ((equal arg2 "lits") (setf *var-policy* 'lits))
			     ((equal arg2 "all") (setf *var-policy* 'all))
			     (t (return (format t "unknown var policy: ~A~%" (second args)))))
		       (setf args (cddr args))))
		    ((equal arg "-pf")
		     (setf *pf-sharingp* nil)
		     (setf args (cdr args)))
		    ((equal arg "+pf")
		     (setf *pf-sharingp* t)
		     (setf args (cdr args)))
		    ((equal arg "-try")
		     (setf *tryp* nil)
		     (setf args (cdr args)))
		    ((equal arg "+try")
		     (setf *tryp* t)
		     (setf args (cdr args)))
		    ((equal arg "-or")
		     (setf *or-parp* nil)
		     (setf args (cdr args)))
		    ((equal arg "+or")
		     (setf *or-parp* t)
		     (setf args (cdr args)))
		    ((equal arg "-meta")
		     (setf *metap* nil)
		     (setf args (cdr args)))
		    ((equal arg "+meta")
		     (setf *metap* t)
		     (setf args (cdr args)))
		    ((equal arg "-merging")
		     (setf *mergingp* nil)
		     (setf args (cdr args)))
		    ((equal arg "+merging")
		     (setf *mergingp* t)
		     (setf args (cdr args)))
		    ((equal arg "-matching")
		     (setf *matchingp* nil)
		     (setf args (cdr args)))
		    ((equal arg "+matching")
		     (setf *matchingp* t)
		     (setf args (cdr args)))
		    ((equal arg "-l")
		     (setf *lp* nil)
		     (setf args (cdr args)))
		    ((equal arg "+l")
		     (setf *lp* t)
		     (setf args (cdr args)))
		    ((equal arg "-d")
		     (setf *df* nil)
		     (setf args (cdr args)))
		    ((equal arg "+d")
		     (setf *df* t)
		     (setf args (cdr args)))
		    ((equal arg "-i")
		     (setf *if* nil)
		     (setf args (cdr args)))
		    ((equal arg "+i")
		     (setf *if* t)
		     (setf args (cdr args)))
		    ((equal arg "-u")
		     (setf up nil)
		     (setf args (cdr args)))
		    ((equal arg "+u")
		     (setf up t)
		     (setf args (cdr args)))	    
		    ((equal arg "-r")
		     (setf rp nil)
		     (setf args (cdr args)))
		    ((equal arg "+r")
		     (setf rp t)
		     (setf args (cdr args)))
		    ((equal arg "+s")
		     (setf sp t)
		     (setf args (cdr args)))
		    ((equal arg "-s")
		     (setf sp nil)
		     (setf args (cdr args)))
		    (t
		     (when file
		       (return (format t "correct usage: bat [-solver (zchaff | minisat | siege | none) | -p (full | mem | cnf | none) | -r | +r | -s | +s | -u | +u]* file~%")))
		     (setf file (car args))
		     (setf args (cdr args))))))
      ;;(generic-run "[ -a /tmp/smt ] || mkdir /tmp/smt/" nil nil)
 	(with-open-file (stream file :direction :input)
	  (let ((format (read stream)))
	    (case format
	      (:forall (let ((vars (read stream))
			     (functs (read stream))
			     (form (read stream)))
			 (solve-formula-forall file vars functs form solver :ap ap :up up :rp rp :sp sp)))
	      (:exists (let ((vars (read stream))
			     (functs (read stream))
			     (form (read stream)))
			 (solve-formula-exists file vars functs form solver :ap ap :up up :rp rp :sp sp)))
	      (:machine (let ((desc (read stream))
			      (steps (read stream)))
			  (dbmc file desc steps solver :ap ap :up up :rp rp :sp sp)))))))))
